/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8239;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm8239.STDecoder;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class HubChangeDetector
implements ConfigChangeDetector {
    private static final int RASID = 19;
    private static final int RASSUBID = 19;
    private static int maxhubs = 8;
    private static int cfgvars = 6;
    private static int hubType;
    private static int numPorts;
    private static int eCardType;
    private static int rCardType;
    private static int hOrder;
    private static int segNum;
    int[][] oldHubs = new int[maxhubs][cfgvars];
    int[][] newHubs = new int[maxhubs][cfgvars];
    private static int dIstat;
    private static int dOstat;
    private static int unwrapped;
    private static int wrapped;
    LocalModel hubOrderModel;
    LocalModel summaryModel;

    private int[] rotateOrderArray(int[] nArray) {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "rotateOrderArray");
        }
        int n = 9;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] < n && nArray[n4] >= 0) {
                n = nArray[n4];
                n3 = n4;
            }
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            nArray[n4] = nArray2[(n4 + n3) % n2];
            ++n4;
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "rotateOrderArray");
        }
        return nArray2;
    }

    public int[][] cfginfo(LocalModel localModel) {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "cfginfo");
        }
        int[][] nArray = new int[maxhubs][2];
        int[] nArray2 = new int[maxhubs];
        int[][] nArray3 = new int[maxhubs][cfgvars];
        STDecoder[] sTDecoderArray = new STDecoder[8];
        try {
            Object object;
            if (this.summaryModel == null || this.hubOrderModel == null) {
                if (this.summaryModel == null) {
                    this.summaryModel = localModel.getComponent("StackSummary");
                }
                if (this.hubOrderModel == null) {
                    this.hubOrderModel = localModel.getComponent("StackHubOrder");
                }
            }
            if (this.summaryModel == null || this.hubOrderModel == null) {
                if (RAS.isEnabled(19, 19)) {
                    RAS.exit(19, 19, this, "cfginfo");
                }
                return nArray3;
            }
            Vector vector = this.summaryModel.getRestOfInfo("Panel", "default", null, null);
            if (vector == null) {
                return nArray3;
            }
            if (vector instanceof SpecialValue) {
                return nArray3;
            }
            Vector vector2 = vector;
            int n = vector2.size();
            if (n <= 0) {
                return nArray3;
            }
            ModelInfo modelInfo = this.hubOrderModel.getInfo("Panel", "default", null);
            if (modelInfo == null) {
                return nArray3;
            }
            Serializable serializable = modelInfo.get("Panel.StackMgtHubOrder");
            if (serializable instanceof SpecialValue) {
                return nArray3;
            }
            String string = (String)((Object)serializable);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo2 = (ModelInfo)enumeration.nextElement();
                object = (Integer)modelInfo2.get("Index.StackSummaryHubId");
                sTDecoderArray[((Integer)object).intValue() - 1] = new STDecoder();
                Serializable serializable2 = modelInfo2.get("Panel.StackSummaryInfo");
                sTDecoderArray[(Integer)object - 1].setEntry((OctetString)serializable2);
            }
            int n2 = 0;
            while (n2 < 8) {
                if (sTDecoderArray[n2] != null) {
                    nArray3[n2][HubChangeDetector.hubType] = sTDecoderArray[n2].module(STDecoder.HUBTYPE);
                    nArray3[n2][HubChangeDetector.numPorts] = sTDecoderArray[n2].numberOfPorts();
                    nArray3[n2][HubChangeDetector.eCardType] = sTDecoderArray[n2].module(STDecoder.EXPTYPE);
                    nArray3[n2][HubChangeDetector.rCardType] = sTDecoderArray[n2].module(STDecoder.RIROTYPE);
                    int n3 = sTDecoderArray[n2].version();
                    nArray[n2][HubChangeDetector.dIstat] = sTDecoderArray[n2].module(STDecoder.DATAINSTATUS);
                    nArray[n2][HubChangeDetector.dOstat] = sTDecoderArray[n2].module(STDecoder.DATAOUTSTATUS);
                    if (n3 == STDecoder.V1) {
                        nArray[n2][HubChangeDetector.dIstat] = nArray[n2][dIstat] == unwrapped ? wrapped : unwrapped;
                        nArray[n2][HubChangeDetector.dOstat] = nArray[n2][dOstat] == unwrapped ? wrapped : unwrapped;
                    }
                }
                ++n2;
            }
            object = new StringTokenizer(string, ", ");
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = -1;
                ++n4;
            }
            int n5 = 0;
            while (((StringTokenizer)object).hasMoreElements() && n5 < vector2.size()) {
                Integer n6 = new Integer((String)((StringTokenizer)object).nextElement());
                nArray2[n5] = n6 - 1;
                nArray3[n6.intValue() - 1][HubChangeDetector.hOrder] = n5++;
            }
            nArray2 = this.rotateOrderArray(nArray2);
            int n7 = 0;
            int n8 = n - 1;
            int n9 = 0;
            int n10 = 1;
            while (n7 < n) {
                int n11 = nArray2[n7];
                int n12 = nArray2[n8];
                if (nArray[n11][dIstat] != unwrapped || nArray[n12][dOstat] != unwrapped) {
                    // empty if block
                }
                nArray3[n11][HubChangeDetector.segNum] = ++n9;
                n8 = n7++;
            }
            if (n9 > 0 && nArray[nArray2[0]][dIstat] == unwrapped && nArray[nArray2[n8]][dOstat] == unwrapped && nArray3[nArray2[0]][segNum] != nArray3[nArray2[n8]][segNum]) {
                n10 = nArray3[nArray2[n8]][segNum];
                while (nArray3[nArray2[n8]][segNum] == n10) {
                    nArray3[nArray2[n8--]][HubChangeDetector.segNum] = 0;
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 19, this, "Jdm8239:HubChangeDetector: init() - models not found", exception);
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "cfginfo");
        }
        return nArray3;
    }

    public void init(LocalModel localModel) {
        this.oldHubs = this.cfginfo(localModel);
    }

    public boolean configChanged(LocalModel localModel) {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "configChanged");
        }
        if (localModel == null) {
            if (RAS.isEnabled(19, 19)) {
                RAS.exit(19, 19, this, "configChanged");
            }
            return false;
        }
        int n = 0;
        while (n < maxhubs && this.oldHubs[n][numPorts] == 0) {
            ++n;
        }
        if (n == maxhubs) {
            this.init(localModel);
            if (RAS.isEnabled(19, 19)) {
                RAS.exit(19, 19, this, "configChanged");
            }
            return false;
        }
        this.newHubs = this.cfginfo(localModel);
        int n2 = 0;
        while (n2 < maxhubs) {
            int n3 = 0;
            while (n3 < cfgvars) {
                if (this.newHubs[n2][n3] != this.oldHubs[n2][n3]) {
                    if (RAS.isEnabled(19, 19)) {
                        RAS.trace(19, 19, this, "configChanged", "detected a change in the hubs");
                    }
                    this.oldHubs = this.newHubs;
                    if (RAS.isEnabled(19, 19)) {
                        RAS.exit(19, 19, this, "configChanged");
                    }
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "configChanged");
        }
        return false;
    }

    public void dispose() {
        int n = 0;
        while (n < maxhubs) {
            this.oldHubs[n][0] = 0;
            ++n;
        }
        this.hubOrderModel.dispose();
        this.hubOrderModel = null;
        this.summaryModel.dispose();
        this.summaryModel = null;
    }

    static {
        numPorts = 1;
        eCardType = 2;
        rCardType = 3;
        hOrder = 4;
        segNum = 5;
        dOstat = 1;
        wrapped = 1;
    }
}

